<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAttributesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('attributes', function (Blueprint $table) {
            $table->id();
            $table->string('name_en', 200);
            $table->string('name_ar', 200);
            $table->integer('sort')->nullable();

            $table->unsignedBigInteger('deleted')->default(0);
            $table->softDeletes();
            $table->unique(['name_en', 'deleted']);
            $table->unique(['name_ar', 'deleted']);

            $table->foreign('attribute_group_id')->references('id')->on('attribute_groups')->nullOnDelete();
            $table->bigInteger('attribute_group_id')->unsigned()->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('attributes');
    }
}
