<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('first_name', 50);
            $table->string('last_name', 50);
            $table->string('email');
            $table->string('phone', 50);
            $table->timestamp('email_verified_at')->nullable();
            $table->string('timezone', 30)->nullable();
            $table->enum('locale', ['en', 'ar'])->default('en');
            $table->ipAddress('last_ip')->nullable();
            $table->enum('gender', ['male', 'female'])->nullable();
            $table->dateTime('birth_date')->nullable();
            $table->string('password');
            $table->json('image')->nullable();
            $table->text('firebase_token')->nullable();
            $table->boolean('activated')->nullable();
            $table->boolean('accepted')->default(1);
            $table->boolean('verified')->nullable();
            $table->boolean('is_logged_in')->default(false);
            $table->integer('access_failed_count')->default(0);
            $table->timestamp('last_login_date')->nullable();
            $table->enum('role', ['Super Admin', 'Admin', 'Seller', 'Member', 'Delivery']);
            $table->bigInteger('city_id')->unsigned()->nullable();
            $table->foreign('city_id')->references('id')->on('world_cities');

            $table->rememberToken();
            $table->unsignedBigInteger('deleted')->default(0);
            $table->softDeletes();
            $table->unique(['email', 'deleted']);
            $table->unique(['phone', 'deleted']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
