<?php

namespace App\Models;

use App\Http\Traits\HasSearch;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Payment extends Model
{
    use HasFactory, HasSearch, SoftDeletes;

    protected $searchable = [
        'name_en',
        'name_ar',
    ];

    protected $guarded = ['id'];

    protected $casts = [
        'activated' => 'boolean'
    ];

    public function scopeActive($query, $active)
    {
        return $query->when($active !== null, function ($query) use ($active) {
            $query->where('activated', '=', boolval($active));
        });
    }

    public function products(): BelongsToMany
    {
        return $this->belongsToMany(Product::class, 'payment_product', 'payment_id', 'product_id');
    }

}
