<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Cart extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    protected $appends = [
        'formatted_total',
        'formatted_subtotal',
        'formatted_tax',
        'formatted_discount_total',
        'formatted_delivery_total',
        'formatted_shipping_total'
    ];

    public function getTotalAttribute($value)
    {
        $userCurrency = request()->query('currency', 'USD');
        return currency($value, 'USD', $userCurrency, false);
    }

    public function getSubtotalAttribute($value)
    {
        $userCurrency = request()->query('currency', 'USD');
        return currency($value, 'USD', $userCurrency, false);
    }

    public function getTaxAttribute($value)
    {
        $userCurrency = request()->query('currency', 'USD');
        return currency($value, 'USD', $userCurrency, false);
    }

    public function getDiscountTotalAttribute($value)
    {
        $userCurrency = request()->query('currency', 'USD');
        return currency($value, 'USD', $userCurrency, false);
    }

    public function getDeliveryTotalAttribute($value)
    {
        $userCurrency = request()->query('currency', 'USD');
        return currency($value, 'USD', $userCurrency, false);
    }

    public function getShippingTotalAttribute($value)
    {
        $userCurrency = request()->query('currency', 'USD');
        return currency($value, 'USD', $userCurrency, false);
    }

    public function getFormattedTotalAttribute($value)
    {
        $userCurrency = request()->query('currency', 'USD');
        return currency($value, 'USD', $userCurrency, true);
    }

    public function getFormattedSubtotalAttribute($value)
    {
        $userCurrency = request()->query('currency', 'USD');
        return currency($value, 'USD', $userCurrency, true);
    }

    public function getFormattedTaxAttribute($value)
    {
        $userCurrency = request()->query('currency', 'USD');
        return currency($value, 'USD', $userCurrency, true);
    }

    public function getFormattedDiscountTotalAttribute($value)
    {
        $userCurrency = request()->query('currency', 'USD');
        return currency($value, 'USD', $userCurrency, true);
    }

    public function getFormattedDeliveryTotalAttribute($value)
    {
        $userCurrency = request()->query('currency', 'USD');
        return currency($value, 'USD', $userCurrency, true);
    }

    public function getFormattedShippingTotalAttribute($value)
    {
        $userCurrency = request()->query('currency', 'USD');
        return currency($value, 'USD', $userCurrency, true);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class)->withTrashed();
    }

    public function seller(): BelongsTo
    {
        return $this->belongsTo(Seller::class)->withTrashed();
    }

    public function deliveryOption(): BelongsTo
    {
        return $this->belongsTo(DeliveryOption::class)->withTrashed();
    }

    public function coupon(): BelongsTo
    {
        return $this->belongsTo(Coupon::class)->withTrashed();
    }

    public function cartItems(): HasMany
    {
        return $this->hasMany(CartItem::class)->withTrashed();
    }
}
