<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class PasswordResetRequest extends Mailable
{
    use Queueable, SerializesModels;

    public $actionURL, $fullName, $code;

    public function __construct($actionURL, $fullName,$code)
    {
        $this->actionURL = $actionURL;
        $this->fullName = $fullName;
        $this->code = $code;
    }

    public function build()
    {
        return $this->subject('TalabatExpress Account Password Reset')->view('reset_password');
    }
}
