<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class SliderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules(): array
    {
        $isPost = $this->method() == 'POST';
        if ($isPost) {
            $rules = [
                'sort' => ['nullable',],
                'description' => ['required', 'string'],
                'category_id' => ['required',Rule::exists('product_categories','id')->whereNull('deleted_at')],
                'type' => ['required', Rule::in(['main', 'secondary'])],
                'image' => ['required'],
            ];
        }
        else{
            $rules = [
                'sort' => ['nullable',],
                'description' => ['required', 'string'],
                'category_id' => ['required',Rule::exists('product_categories','id')->whereNull('deleted_at')],
                'image' => ['required'],
            ];
        }
        return $rules;
    }
}
