<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Support\Facades\Response;
use Illuminate\Validation\Rule;

class BrandRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        if ($this->getMethod() === 'PATCH') {
            return [
                'special' => [
                    'required',
                    'boolean']
            ];
        }
        if ($this->getMethod() === 'POST') {
            return [
                'name_en' => [
                    'required'
                    , 'different:name_ar', Rule::unique('brands')->where('deleted', 0)
                ],
                'name_ar' => [
                    'required'
                    , 'different:name_en', Rule::unique('brands')->where('deleted', 0)],
                'image' => [
                    'nullable'
                ],
                'special' => [
                    'required',
                    'boolean'
                ],
                'sort' => [
                    'required',
                    'integer',
                    'min:1'
                ],
            ];
        }
        return [
            'name_en' => ['required', 'different:name_ar', Rule::unique('brands')
                ->where('deleted', 0)
                ->ignore(request()->route('id'))],
            'name_ar' => ['required', 'different:name_en', Rule::unique('brands')
                ->where('deleted', 0)
                ->ignore(request()->route('id'))],
            'image' => [
                'nullable'
            ],
            'activated' => [
                'required'
                , 'boolean'
            ],
            'special' => [
                'required',
                'boolean'
            ],
            'sort' => [
                'required',
                'integer',
                'min:1'
            ],
        ];
    }

    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(Response::failure($validator->errors()->first()));
    }
}
