<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Support\Facades\Response;
use Illuminate\Validation\Rule;

class AssignOrderToDeliveryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        return [
            'order_id' => ['required', Rule::exists('orders', 'id')
                ->whereNot('delivery_method', 'pickup')
                ->whereIn('state', ['assigned_to_delivery', 'approved'])
            ],
            'user_id' => ['required', Rule::exists('users', 'id')
                ->where('accepted', '1')
                ->where('role', 'Delivery')
                ->whereNull('deleted_at')],
            'warehouse_id' => ['required', Rule::exists('warehouses', 'id')
            ],
        ];
    }

    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(Response::failure($validator->errors()->first()));
    }
}
