<?php

namespace App\Http\Controllers;

use GuzzleHttp\Client;
use Khsing\World\Models\City;
use Khsing\World\Models\Country;

class ConfigController extends Controller
{
    public function updateCountriesTimezonesAndCodes()
    {
        $client = new Client();
        $collection = collect(json_decode($client->get('http://api.timezonedb.com/v2.1/list-time-zone?key=DZ3RVUWX4M57&by&format=json')
            ->getBody(), true)['zones']);
        //return response()->json($collection);
        $countries = Country::all();
        foreach ($countries as $country) {
            $item = $collection->first(function ($item) use ($country) {
                return $item['countryName'] === $country->name;
            });
            if ($item !== null) {
                $country->update([
                    'timezone' => $item['zoneName']
                ], ['timestamps' => false]);
            }
        }
    }

    public function insertMissingCities()
    {
        City::query()->insert([
            array(
                'country_id' => 78,
                'division_id' => NULL,
                'name' => 'Al Ahmadi',
                'full_name' => NULL,
                'code' => '',
            ),
            array(

                'country_id' => 78,
                'division_id' => NULL,
                'name' => 'Hawalli',
                'full_name' => NULL,
                'code' => '',
            ),
            array(

                'country_id' => 78,
                'division_id' => NULL,
                'name' => 'As Salimiyah',
                'full_name' => NULL,
                'code' => '',
            ),
            array(

                'country_id' => 78,
                'division_id' => NULL,
                'name' => 'Sabah as Salim',
                'full_name' => NULL,
                'code' => '',
            ),
            array(

                'country_id' => 78,
                'division_id' => NULL,
                'name' => 'Al Farwaniyah',
                'full_name' => NULL,
                'code' => '',
            ),
            array(

                'country_id' => 78,
                'division_id' => NULL,
                'name' => 'Al Fahahil',
                'full_name' => NULL,
                'code' => '',
            ),
            array(

                'country_id' => 78,
                'division_id' => NULL,
                'name' => 'Kuwait City',
                'full_name' => NULL,
                'code' => '',
            ),
            array(

                'country_id' => 78,
                'division_id' => NULL,
                'name' => 'Ar Rumaythiyah',
                'full_name' => NULL,
                'code' => '',
            ),
            array(

                'country_id' => 78,
                'division_id' => NULL,
                'name' => 'Ar Riqqah',
                'full_name' => NULL,
                'code' => '',
            ),
            array(

                'country_id' => 78,
                'division_id' => NULL,
                'name' => 'Salwa',
                'full_name' => NULL,
                'code' => '',
            ),
            array(

                'country_id' => 78,
                'division_id' => NULL,
                'name' => 'Al Manqaf',
                'full_name' => NULL,
                'code' => '',
            ),
            array(

                'country_id' => 78,
                'division_id' => NULL,
                'name' => 'Ar Rabiyah',
                'full_name' => NULL,
                'code' => '',
            ),
            array(

                'country_id' => 78,
                'division_id' => NULL,
                'name' => 'Bayan',
                'full_name' => NULL,
                'code' => '',
            ),
            array(

                'country_id' => 78,
                'division_id' => NULL,
                'name' => 'Al Jahra',
                'full_name' => NULL,
                'code' => '',
            ),
            array(

                'country_id' => 78,
                'division_id' => NULL,
                'name' => 'Al Fintas',
                'full_name' => NULL,
                'code' => '',
            ),
            array(

                'country_id' => 78,
                'division_id' => NULL,
                'name' => 'Janub as Surrah',
                'full_name' => NULL,
                'code' => '',
            ),
            array(

                'country_id' => 78,
                'division_id' => NULL,
                'name' => 'Al Mahbulah',
                'full_name' => NULL,
                'code' => '',
            ),
            array(

                'country_id' => 78,
                'division_id' => NULL,
                'name' => 'Ad Dasmah',
                'full_name' => NULL,
                'code' => '',
            ),
            array(

                'country_id' => 78,
                'division_id' => NULL,
                'name' => 'Ash Shamiyah',
                'full_name' => NULL,
                'code' => '',
            ),
            array(

                'country_id' => 78,
                'division_id' => NULL,
                'name' => 'Al Wafrah',
                'full_name' => NULL,
                'code' => '',
            ),
            array(

                'country_id' => 78,
                'division_id' => NULL,
                'name' => 'Elbasan',
                'full_name' => NULL,
                'code' => '',
            ),
            array(

                'country_id' => 78,
                'division_id' => NULL,
                'name' => 'Az Zawr',
                'full_name' => NULL,
                'code' => '',
            ),
            array(

                'country_id' => 78,
                'division_id' => NULL,
                'name' => 'Mubarak al Kabir',
                'full_name' => NULL,
                'code' => '',
            ),
        ]);
    }
}
