<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\SizeRequest;
use App\Models\Size;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Response;

class SizeController extends Controller
{
    public function __construct()
    {
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('has_permission:create_product')->only(['store']);
            $this->middleware('has_permission:update_product')->only(['update']);
            $this->middleware('has_permission:delete_product')->only(['delete']);
        }
    }

    public function store(SizeRequest $request): JsonResponse
    {
        $size = Size::query()->create($request->validated());
        return Response::success($size);
    }

    public function update(SizeRequest $request, $id): JsonResponse
    {
        $size = Size::query()
            ->findOrFail($id);
        $size->update($request->validated());
        return Response::success($size);
    }

    public function destroy($id): JsonResponse
    {
        Size::query()->findOrFail($id)->delete();
        return Response::success(null);

    }
}
