<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\NotificationRequest;
use App\Models\Notification;
use App\Services\NotificationService;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response;

class NotificationController extends Controller
{
    private $notificationService;

    public function __construct(NotificationService $notificationService)
    {
        $this->notificationService = $notificationService;
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('has_permission:view_notification')->only(['index']);
            $this->middleware('has_permission:create_notification')->only(['store']);
        }
    }

    public function index(): JsonResponse
    {
        return Response::success(Notification::search(request()->query('word_filter'))
            ->when(request()->query('role') != null, function ($query) {
                $query->where(function ($query) {
                    $query->where('role', '=', request()->query('role'));
                });
            })
            ->where('pivot', '=', true)
            ->orderByDesc('notified_at'));
    }

    public function store(NotificationRequest $request): JsonResponse
    {
        $data = $request->validated();
        $notifications = $this->notificationService->sendToRole(Auth::user()->timezone, NotificationService::OTHERS, $data);
        return Response::success($notifications);
    }

    public function destroy($group): JsonResponse
    {
        Notification::query()->where('group', '=', $group)->delete();
        return Response::success(null);
    }
}
