<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\GalleryImageRequest;
use App\Models\GalleryImage;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Response;

class GalleryImageController extends Controller
{
    public function __construct()
    {
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('has_permission:view_gallery_images')->only(['index', 'export', 'show']);
            $this->middleware('has_permission:create_gallery_images')->only('store');
            $this->middleware('has_permission:update_gallery_images')->only('update');
            $this->middleware('has_permission:delete_gallery_images')->only('destroy');
        }
    }
    public function index(): JsonResponse
    {
        return Response::success(GalleryImage::query());
    }

    public function store(GalleryImageRequest $request): JsonResponse
    {
        return Response::success(GalleryImage::query()->create($request->validated()));
    }

    public function show(GalleryImage $galleryImage): JsonResponse
    {
        return Response::success($galleryImage);
    }

    public function update(GalleryImageRequest $request, GalleryImage $galleryImage): JsonResponse
    {
        return Response::success($galleryImage->update($request->validated()));
    }

    public function destroy(GalleryImage $galleryImage): JsonResponse
    {
        return Response::success($galleryImage->delete());
    }
}
