<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\AttributeGroupRequest;
use App\Models\AttributeGroup;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Response;

class AttributeGroupController extends Controller
{

    public function __construct()
    {
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('has_permission:view_attribute')->only(['index', 'export', 'show']);
            $this->middleware('has_permission:create_attribute')->only(['store']);
            $this->middleware('has_permission:update_attribute')->only(['update']);
            $this->middleware('has_permission:delete_attribute')->only(['delete']);
        }
    }

    public function index(): JsonResponse
    {
        return Response::success(
            AttributeGroup::query()
                ->orderByDesc('sort')
        );
    }

    public function show($id): JsonResponse
    {
        return Response::success(
            AttributeGroup::query()->with(['attributes'])->find($id)
        );
    }

    public function store(AttributeGroupRequest $request): JsonResponse
    {
        $input = $request->validated();
        return Response::success(AttributeGroup::query()->create($input));

    }

    public function update(AttributeGroupRequest $request, $id): JsonResponse
    {
        $attributeGroup = AttributeGroup::query()
            ->findOrFail($id);
        $attributeGroup->update($request->validated());
        return Response::success($attributeGroup->load(['attributes']));
    }

    public function destroy($id): JsonResponse
    {
        $attributeGroup = AttributeGroup::query()->findOrFail($id);
        if ($attributeGroup->attributes()->count() > 0) {
            return Response::failure(__('common.error_delete_item'));
        }
        $attributeGroup->forceDelete();
        return Response::success(null);

    }
}
