<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\AttributeRequest;
use App\Models\Attribute;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Response;

class AttributeController extends Controller
{

    public function __construct()
    {
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('has_permission:view_attribute')->only(['index', 'export', 'show']);
            $this->middleware('has_permission:create_attribute')->only(['store']);
            $this->middleware('has_permission:update_attribute')->only(['update']);
            $this->middleware('has_permission:delete_attribute')->only(['delete']);
        }
    }

    public function index(): JsonResponse
    {
        return Response::success(
            Attribute::search(request()->query('word_filter'))
                ->orderByDesc('sort')
        );
    }

    public function show($id): JsonResponse
    {
        return Response::success(
            Attribute::query()->with(['group'])->find($id)
        );
    }

    public function store(AttributeRequest $request): JsonResponse
    {
        $input = $request->validated();
        return Response::success(Attribute::query()->create($input));

    }

    public function update(AttributeRequest $request, $id): JsonResponse
    {
        $attribute = Attribute::query()
            ->findOrFail($id);
        $attribute->update($request->validated());
        return Response::success($attribute->load(['group']));
    }

    public function destroy($id): JsonResponse
    {
        $attribute = Attribute::query()->findOrFail($id);
        if ($attribute->products()->count() > 0) {
            return Response::failure(__('common.error_delete_item'));
        }
        $attribute->forceDelete();
        return Response::success(null);
    }
}
