<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Http\Requests\ReviewRequest;
use App\Models\Review;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response;

class ReviewController extends Controller
{

    public function __construct()
    {
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('is_member');
            $this->middleware('is_active');
        }
    }

    public function show($id): JsonResponse
    {
        return Response::success(
            Review::query()->where('user_id', '=', Auth::user()->id)->with(['product', 'user'])->find($id)
        );
    }

    public function store(ReviewRequest $request): JsonResponse
    {
        $input = $request->validated();
        $input['state'] = 'new';
        $input['user_id'] = Auth::user()->id;
        return Response::success(Review::query()->create($input));
    }

    public function update(ReviewRequest $request, $id): JsonResponse
    {
        $review = Review::query()
            ->where('user_id', '=', Auth::user()->id)
            ->findOrFail($id);
        $input = $request->validated();
        $input['state'] = 'new';
        $input['user_id'] = Auth::user()->id;
        $review->update($input);
        return Response::success($review->load(['product', 'user']));
    }

    public function destroy($id): JsonResponse
    {
        Review::query()->where('user_id', '=', Auth::user()->id)->findOrFail($id)->delete();
        return Response::success(null);
    }
}
