<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Services\NotificationService;
use DateTimeZone;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Response;
use Khsing\World\Models\Country;


class PublicController extends Controller
{
    public function test(NotificationService $notificationService): JsonResponse
    {
        $notificationData = [
            'role' => 'Super Admin',
            'title' => __('common.message_order_placed_title', ['fullname' =>'test']),
            'body' => __('common.message_order_placed_body', ['fullname' => 'test'])
        ];
        $notificationService->sendToRole('Asia/Kuwait', NotificationService::ORDERS, $notificationData);
        return \response()->json(['asd' => 'ads']);
    }

    public function timezone(): JsonResponse
    {
        return Response::success(DateTimeZone::listIdentifiers());
    }

    public function currency(): JsonResponse
    {
        $countries = Country::query()->get()->groupBy('currency_code');
        return Response::success(collect(currency()->getCurrencies())->map(function ($item) use ($countries) {
            $item['country'] = null;
            $country = $countries->get($item['code']);
            $item['country'] = $country !== null ? $country->first() : null;
            return $item;
        }));
    }

    public function unauthorized(): JsonResponse
    {
        return Response::success([
            'session' => 'expired',
            'error' => 'Session has expired. Please sign in and try again.'
        ], 302);
    }
}
