<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Response;
use Khsing\World\Models\Country;

class CountryController extends Controller
{
    public function index(): JsonResponse
    {
        return Response::success(Country::search(request()->query('word_filter'))->where('active', '=', '1'));
    }

    public function show($id): JsonResponse
    {
        return Response::success(Country::query()->where('active', '=', '1')->with(['cities'])->find($id));
    }
}
