<?php
return [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted' => 'The :attribute must be accepted.',
    'active_url' => 'The :attribute is not a valid URL.',
    'after' => 'The :attribute must be a date after :date.',
    'after_or_equal' => 'The :attribute must be a date after or equal to :date.',
    'alpha' => 'The :attribute must only contain letters.',
    'alpha_dash' => 'The :attribute must only contain letters, numbers, dashes and underscores.',
    'alpha_num' => 'The :attribute must only contain letters and numbers.',
    'array' => 'The :attribute must be an array.',
    'before' => 'The :attribute must be a date before :date.',
    'before_or_equal' => 'The :attribute must be a date before or equal to :date.',
    'between' => [
        'numeric' => 'The :attribute must be between :min and :max.',
        'file' => 'The :attribute must be between :min and :max kilobytes.',
        'string' => 'The :attribute must be between :min and :max characters.',
        'array' => 'The :attribute must have between :min and :max items.',
    ],
    'boolean' => 'The :attribute field must be true or false.',
    'confirmed' => 'The :attribute confirmation does not match.',
    'date' => 'The :attribute is not a valid date.',
    'date_equals' => 'The :attribute must be a date equal to :date.',
    'date_format' => 'The :attribute does not match the format :format.',
    'different' => 'The :attribute and :other must be different.',
    'digits' => 'The :attribute must be :digits digits.',
    'digits_between' => 'The :attribute must be between :min and :max digits.',
    'dimensions' => 'The :attribute has invalid image dimensions.',
    'distinct' => 'The :attribute field has a duplicate value.',
    'email' => 'The :attribute must be a valid email address.',
    'ends_with' => 'The :attribute must end with one of the following: :values.',
    'exists' => 'The selected :attribute is invalid.',
    'file' => 'The :attribute must be a file.',
    'filled' => 'The :attribute field must have a value.',
    'gt' => [
        'numeric' => 'The :attribute must be greater than :value.',
        'file' => 'The :attribute must be greater than :value kilobytes.',
        'string' => 'The :attribute must be greater than :value characters.',
        'array' => 'The :attribute must have more than :value items.',
    ],
    'gte' => [
        'numeric' => 'The :attribute must be greater than or equal :value.',
        'file' => 'The :attribute must be greater than or equal :value kilobytes.',
        'string' => 'The :attribute must be greater than or equal :value characters.',
        'array' => 'The :attribute must have :value items or more.',
    ],
    'image' => 'The :attribute must be an image.',
    'in' => 'The selected :attribute is invalid.',
    'in_array' => 'The :attribute field does not exist in :other.',
    'integer' => 'The :attribute must be an integer.',
    'ip' => 'The :attribute must be a valid IP address.',
    'ipv4' => 'The :attribute must be a valid IPv4 address.',
    'ipv6' => 'The :attribute must be a valid IPv6 address.',
    'json' => 'The :attribute must be a valid JSON string.',
    'lt' => [
        'numeric' => 'The :attribute must be less than :value.',
        'file' => 'The :attribute must be less than :value kilobytes.',
        'string' => 'The :attribute must be less than :value characters.',
        'array' => 'The :attribute must have less than :value items.',
    ],
    'lte' => [
        'numeric' => 'The :attribute must be less than or equal :value.',
        'file' => 'The :attribute must be less than or equal :value kilobytes.',
        'string' => 'The :attribute must be less than or equal :value characters.',
        'array' => 'The :attribute must not have more than :value items.',
    ],
    'max' => [
        'numeric' => 'The :attribute must not be greater than :max.',
        'file' => 'The :attribute must not be greater than :max kilobytes.',
        'string' => 'The :attribute must not be greater than :max characters.',
        'array' => 'The :attribute must not have more than :max items.',
    ],
    'mimes' => 'The :attribute must be a file of type: :values.',
    'mimetypes' => 'The :attribute must be a file of type: :values.',
    'min' => [
        'numeric' => 'The :attribute must be at least :min.',
        'file' => 'The :attribute must be at least :min kilobytes.',
        'string' => 'The :attribute must be at least :min characters.',
        'array' => 'The :attribute must have at least :min items.',
    ],
    'multiple_of' => 'The :attribute must be a multiple of :value.',
    'not_in' => 'The selected :attribute is invalid.',
    'not_regex' => 'The :attribute format is invalid.',
    'numeric' => 'The :attribute must be a number.',
    'password' => 'The password is incorrect.',
    'present' => 'The :attribute field must be present.',
    'regex' => 'The :attribute format is invalid.',
    'required' => 'The :attribute field is required.',
    'required_if' => 'The :attribute field is required when :other is :value.',
    'required_unless' => 'The :attribute field is required unless :other is in :values.',
    'required_with' => 'The :attribute field is required when :values is present.',
    'required_with_all' => 'The :attribute field is required when :values are present.',
    'required_without' => 'The :attribute field is required when :values is not present.',
    'required_without_all' => 'The :attribute field is required when none of :values are present.',
    'prohibited' => 'The :attribute field is prohibited.',
    'prohibited_if' => 'The :attribute field is prohibited when :other is :value.',
    'prohibited_unless' => 'The :attribute field is prohibited unless :other is in :values.',
    'same' => 'The :attribute and :other must match.',
    'size' => [
        'numeric' => 'The :attribute must be :size.',
        'file' => 'The :attribute must be :size kilobytes.',
        'string' => 'The :attribute must be :size characters.',
        'array' => 'The :attribute must contain :size items.',
    ],
    'starts_with' => 'The :attribute must start with one of the following: :values.',
    'string' => 'The :attribute must be a string.',
    'timezone' => 'The :attribute must be a valid zone.',
    'unique' => 'The :attribute has already been taken.',
    'uploaded' => 'The :attribute failed to upload.',
    'url' => 'The :attribute format is invalid.',
    'uuid' => 'The :attribute must be a valid UUID.',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap our attribute placeholder
    | with something more reader friendly such as "E-Mail Address" instead
    | of "email". This simply helps us make our message more expressive.
    |
    */

    'attributes' => [
        'first_name' => 'First Name',
        'last_name' => 'Last Name',
        'email' => 'E-Mail Address',
        'phone' => 'Mobile Number',
        'email_verified_at' => 'Email Verification Date',
        'timezone' => 'Timezone',
        'locale' => 'Locale',
        'last_ip' => 'Last IP',
        'gender' => 'Gender',
        'birth_date' => 'Birthdate',
        'password' => 'Password',
        'image' => 'Image',
        'firebase_token' => 'Firebase Token',
        'activated' => 'Activated',
        'accepted' => 'Accepted',
        'verified' => 'Verified',
        'is_logged_in' => 'Logged In',
        'access_failed_count' => 'Access Failed Count',
        'last_login_date' => 'Last Login Date',
        'role' => 'Role',
        'city_id' => 'City',
        'token' => 'Token',
        'orders' => 'Orders Notification',
        'others' => 'Others Notification',
        'emails' => 'Email Notification',
        'image_quality' => 'Image Quality',
        'user_id' => 'User',
        'text_ar' => 'Text in Arabic',
        'text_en' => 'Text in English',
        'address' => 'Address',
        'facebook' => 'Facebook Link',
        'instagram' => 'instagram Link',
        'twitter' => 'Twitter Link',
        'apple' => 'Apple Link',
        'google' => 'Google Link',
        'website_link' => 'Website Link',
        'name_en' => 'Name in English',
        'name_ar' => 'Name in Arabic',
        'special' => 'Special',
        'date' => 'Date',
        'name' => 'Name',
        'phone_number' => 'Mobile Number',
        'message' => 'Message',
        'title' => 'Title',
        'body' => 'Body',
        'code' => 'Code',
        'percentage' => 'Percentage',
        'amount' => 'Amount',
        'creation' => 'Creation Date',
        'expiration' => 'Expiration Date',
        'used' => 'Used',
        'for_marketing' => 'For Digital Marketing',
        'on_delivery_cost' => 'On Delivery Cost',
        'type' => 'Type',
        'cost' => 'Cost',
        'estimated_hours' => 'Estimated Hours',
        'question_ar' => 'Question in Arabic',
        'question_en' => 'Question in English',
        'answer_en' => 'Answer in English',
        'answer_ar' => 'Answer in Arabic',
        'users_verification' => 'Users Verification Enabled',
        'description_en' => 'Description in English',
        'description_ar' => 'Description in Arabic',
        'you_may_like' => 'You May Like',
        'seen' => 'Seen',
        'title_ar' => 'Title in Arabic',
        'title_en' => 'Title in English',
        'body_ar' => 'Body field in Arabic',
        'icon' => 'Icon',
        'notified_at' => 'Notified at Date',
        'short_description_en' => 'Short Description in English',
        'short_description_ar' => 'Short Description in Arabic',
        'meta_tag_title_en' => 'Meta Tag Title in English',
        'meta_tag_title_ar' => 'Meta Tag Title in Arabic',
        'meta_tag_keywords_en' => 'Meta Tag keywords in English',
        'meta_tag_keywords_ar' => 'Meta Tag keywords in Arabic',
        'tags' => 'Tags',
        'seo' => 'SEO',
        'best_collection' => 'Best Collection',
        'newly_added' => 'Newly Added',
        'flash_deal' => 'Flash Deal',
        'selected' => 'Selected',
        'barcode' => 'Barcode',
        'sku' => 'SKU',
        'location' => 'Location',
        'latitude' => 'Latitude',
        'longitude' => 'Longitude',
        'price' => 'Price',
        'quantity' => 'Question',
        'min_quantity' => 'Minimum Quantity',
        'max_quantity' => 'Max Quantity',
        'subtract_stock' => 'Subtotal Stock',
        'shipping_timing' => 'Shipping Timing',
        'requires_shipping' => 'Requires Shipping',
        'availability_date' => 'Availability Date',
        'length_class' => 'Length Class',
        'dimensions' => 'Dimensions',
        'weight_class' => 'Weight Class',
        'weight' => 'Weight',
        'discount' => 'Discount',
        'special_offer' => 'Special Offer',
        'sort' => 'Sort',
        'video' => 'Video',
        'images' => 'Images',
        'required_points' => 'Required Points',
        'brand_id' => 'Brand',
        'seller_id' => 'Seller',
        'out_of_stock_id' => 'Out of Stock',
        'deleted' => 'Deleted',
        'delivery_option_id' => 'Delivery Option',
        'product_id' => 'Product',
        'attribute_id' => 'Attribute',
        'value_en' => 'Value in English',
        'value_ar' => 'Value in Arabic',
        'association_id' => 'Association',
        'product_association_id' => 'Product Association',
        'category_id' => 'Category',
        'hex' => 'Color Hex',
        'payment_id' => 'Payment',
        'region' => 'Region',
        'district' => 'District',
        'street_address' => 'Street Address',
        'boulevard' => 'Boulevard',
        'house' => 'House',
        'apartment' => 'Apartment',
        'company' => 'Company',
        'province' => 'Province',
        'floor' => 'Floor',
        'city' => 'City',
        'postal_code' => 'Postal Code',
        'default' => 'Default',
        'country_id' => 'Country',
        'supplier_since' => 'Supplier Since',
        'corporation_name' => 'Corporation Name',
        'number' => 'Order Number',
        'state' => 'Order State',
        'total' => 'Total',
        'subtotal' => 'Subtotal',
        'tax' => 'Tax',
        'currency' => 'Currency',
        'total_quantity' => 'Total Quantity',
        'notes' => 'Notes',
        'discount_total' => 'Discount Total',
        'coupon_total' => 'Coupon Total',
        'deliverable' => 'Deliverable',
        'delivery_assign_date' => 'Delivery Assign Date',
        'delivered_date' => 'Delivered Date',
        'delivery_method' => 'Delivery Method',
        'delivery_total' => 'Delivery Total',
        'delivery_time' => 'Delivery TIme',
        'delivery_distance' => 'Delivery Distance',
        'post_process' => 'Post Processed',
        'post_url' => 'Post URL',
        'payment_state' => 'Payment State',
        'tap_token' => 'Tap Token',
        'tap_id' => 'Tap ID',
        'shipping_state' => 'Shipping State',
        'shipped_date' => 'Shipping Date',
        'shipping_total' => 'Shipping Total',
        'delivery_id' => 'Delivery',
        'billing_address_id' => 'Billing Address',
        'shipping_address_id' => 'Shipping Address',
        'coupon_id' => 'Coupon',
        'order_id' => 'Order',
        'unit_name_en' => 'Unit Name in English',
        'unit_name_ar' => 'Unit Name in Arabic',
        'unit_dimensions' => 'Unit Dimensions',
        'unit_weight' => 'Unit Weight',
        'unit_price' => 'Unit Price',
        'unit_discount' => 'Unit Discount',
        'unit_special_offer' => 'Unit Special Offer',
        'unit_image' => 'Unit Image',
        'unit_color' => 'Unit Color',
        'unit_size' => 'Unit Size',
        'subtracted' => 'Subtracted',
        'brand_name_en' => 'Brand Name in English',
        'brand_name_ar' => 'Brand Name in Arabic',
        'purchased_with_points' => 'Purchased with Points',
        'points' => 'Points',
        'special_offer_total' => 'Special Offer Total',
        'comment' => 'Comment',
        'rating' => 'Rating',
    ]

];
