<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrderItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('order_items', function (Blueprint $table) {
            $table->id();
            $table->timestamp('date')->nullable();
            $table->text('unit_name_en');
            $table->text('unit_name_ar');
            $table->json('unit_dimensions')->nullable();
            $table->float('unit_weight')->nullable();
            $table->decimal('unit_price', 30, 3);
            $table->json('unit_discount')->nullable();
            $table->json('unit_special_offer')->nullable();
            $table->json('unit_image')->nullable();
            $table->json('unit_color')->nullable();
            $table->json('unit_size')->nullable();
            $table->integer('subtracted')->default(0);
            $table->string('brand_name_en', 150);
            $table->string('brand_name_ar', 150);

            $table->boolean('purchased_with_points')->default(0);
            $table->bigInteger('points')->default(0);
            $table->decimal('tax', 30, 3);
            $table->decimal('total', 30, 3);
            $table->decimal('subtotal', 30, 3);
            $table->decimal('discount_total', 30, 3);
            $table->decimal('special_offer_total', 30, 3);
            $table->bigInteger('quantity')->default(1);
            $table->text('notes')->nullable();
            $table->bigInteger('order_id')->unsigned()->nullable();
            $table->foreign('order_id')->references('id')->on('orders');
            $table->bigInteger('product_id')->unsigned()->nullable();
            $table->foreign('product_id')->references('id')->on('products');
            $table->bigInteger('seller_id')->nullable()->unsigned();
            $table->foreign('seller_id')->references('id')->on('sellers');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('order_items');
    }
}
