<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAppPreferencesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('app_preferences', function (Blueprint $table) {
            $table->id();
            $table->boolean('orders')->default(true);
            $table->boolean('promotions')->default(true);
            $table->boolean('others')->default(true);
            $table->boolean('emails')->default(true);

            $table->enum('image_quality', ['High Quality', 'Normal Quality'])->default('Normal Quality');

            $table->bigInteger('user_id')->nullable()->unsigned();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('CASCADE');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('app_preferences');
    }
}
