<?php


namespace App\Services\MediaLibrary;


use Spatie\MediaLibrary\MediaCollections\Models\Media;
use Spatie\MediaLibrary\Support\PathGenerator\PathGenerator;

class TalabatPathGenerator implements PathGenerator
{

    public function getPath(Media $media): string
    {
        $array = explode('\\', $media->model_type);
        $model = end($array);
        return "Media/$model/{$media->getKey()}/";
    }

    public function getPathForConversions(Media $media): string
    {
        $array = explode('\\', $media->model_type);
        $model = end($array);
        return "Media/$model/{$media->getKey()}/conversions/";
    }

    public function getPathForResponsiveImages(Media $media): string
    {
        $array = explode('\\', $media->model_type);
        $model = end($array);
        return "Media/$model/{$media->getKey()}/responsiveImages/";
    }
}
