<?php


namespace App\Services\Geo;


use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Support\Facades\Http;
use Throwable;

class GeoService
{
    function googleGeoCode($address, $locale = 'en')
    {
        $response = Http::get(config('app.google_geo_code_api_url'), [
            'key' => config('app.google_distance_matrix_api_key'),
            'latlng' => "{$address->latitude},{$address->longitude}",
            'language' => $locale,
            'result_type' => 'country'
        ]);
        try {
            $data = $response->json()['results'][0]['address_components'][0]['long_name'];
            if (is_string($data))
                return $data;
            return 'unknown';
        } catch (Throwable $e) {
            //var_dump($response->json());
            return 'unknown';
        }
    }

    function googleDistanceMatrix($origin, $target, $locale = 'en'): array
    {
        $response = Http::get(config('app.google_distance_matrix_api_url'), [
            'key' => config('app.google_distance_matrix_api_key'),
            'origins' => "{$origin->latitude},{$origin->longitude}",
            'destinations' => "{$target->latitude},{$target->longitude}",
            'language' => $locale
        ]);
        $distance = [
            'value' => 0,
            'text' => ''
        ];
        $duration = [
            'value' => 0,
            'text' => ''
        ];
        $destinationName = '';
        $originName = '';
        try {
            $distance = $response->json()['rows'][0]['elements'][0]['distance'];
            $duration = $response->json()['rows'][0]['elements'][0]['duration'];
            $destinationName = $response->json()['destination_addresses'];
            $originName = $response->json()['origin_addresses'];
        } catch (Throwable $e) {
        }
        if ($response->successful()) {
            return [
                'distance' => $distance,
                'duration' => $duration,
                'destination_name' => $destinationName,
                'origin_name' => $originName
            ];
        } else {
            throw new HttpResponseException(response()->json(['error' => 'Could not fetch information from Google Services'], 400));
        }
    }
}
