<?php

namespace App\Models;

use App\Http\Traits\HasMediaImage;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\MediaLibrary\HasMedia;

class Size extends Model implements HasMedia
{
    use HasFactory, SoftDeletes, HasMediaImage;

    protected $guarded = ['id'];

    protected $casts = [
        'image' => 'array'
    ];

    protected $mediaImageWithDefaults = false;

    protected $preserveMedia = true;


    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }
}
