<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class Verification extends Mailable
{
    use Queueable, SerializesModels;

    public $fullName, $actionURL,$code, $accountType = '';

    public function __construct($fields, $actionURL)
    {
        $this->fullName = "{$fields['first_name']} {$fields['last_name']}";
        $this->code = $fields['code'];
        $this->actionURL = $actionURL;
    }

    public function build(): Verification
    {
        return $this->subject('TalabatExpress Account Information')->view('verification');
    }
}
