<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ContactRequest extends Mailable
{
    use Queueable, SerializesModels;

    public $date, $name, $email, $mobileNumber, $text;

    /**
     * ContactRequest constructor.
     * @param $date
     * @param $name
     * @param $email
     * @param $mobileNumber
     * @param $message
     */
    public function __construct($date, $name, $email, $mobileNumber, $message)
    {
        $this->date = $date;
        $this->name = $name;
        $this->email = $email;
        $this->mobileNumber = $mobileNumber;
        $this->text = $message;
    }


    public function build()
    {
        return $this->view('contact_request');
    }
}
