<?php


namespace App\Http\Traits;


trait HasUniqueSoftDeletes
{
    protected static function bootHasUniqueSoftDeletes()
    {
        static::deleted(function ($item) {
            $item->deleted = $item->id;
            $item->saveQuietly();
        });
        static::restored(function ($item) {
            $item->deleted = 0;
            $item->saveQuietly();
        });
    }
}
