<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response;
use Illuminate\Validation\Rule;

class ReviewRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        $user = Auth::user();
        $validation = [
            'title' => [
                'required',
                'max:100'
            ],
            'comment' => [
                'required',
                'max:200'
            ],
            'rating' => [
                'required',
                'numeric',
                'between:1,5'
            ],
            'product_id' => [
                'required',
                'integer',
                Rule::exists('products', 'id')
            ],
        ];
        if ($user->member) {
            return $validation;
        } else {
            if ($this->getMethod() === 'POST') {
                return array_merge($validation, [
                    'user_id' => [
                        'required',
                        'integer',
                        Rule::exists('users', 'id')
                    ]
                ]);
            } else {
                return array_merge($validation, [
                    'user_id' => [
                        'required',
                        'integer',
                        Rule::exists('users', 'id')
                    ],
                    'state' => [
                        'required',
                        Rule::in(['accepted', 'rejected'])
                    ]
                ]);
            }
        }

    }

    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(Response::failure($validator->errors()->first()));
    }
}
