<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Support\Facades\Response;
use Illuminate\Validation\Rule;

class PaymentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        return [
            'type' => [
                'required',
                Rule::in(['offline', 'tap_checkout', 'stripe_checkout', 'paypal_express_checkout'])
            ],
            'name_en' => [
                'required',
                'max:100'
            ],
            'name_ar' => [
                'required',
                'max:100'
            ],
            'description_en' => [
                'nullable',
                'max:500'
            ],
            'description_ar' => [
                'nullable',
                'max:500'
            ],
            'instructions_en' => [
                'nullable',
                'max:500'
            ],
            'instructions_ar' => [
                'nullable',
                'max:500'
            ]
        ];
    }

    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(Response::failure($validator->errors()->first()));
    }
}
