<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Support\Facades\Response;
use Illuminate\Validation\Rule;

class CheckoutRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        $guest=$this->filled('guest')?$this->guest:0;
        $billingAddress = [
            'billing_address' => [
                'sometimes',
                'nullable',
                'array'
            ],
            'billing_address.*.first_name' => [
                'nullable'
            ],
            'billing_address.*.last_name' => [
                'nullable'
            ],
            'billing_address.*.company' => [
                'nullable'
            ],
            'billing_address.*.street_address' => [
                'nullable'
            ],
            'billing_address.*.province' => [
                'nullable'
            ],
            'billing_address.*.floor' => [
                'nullable'
            ],
            'billing_address.*.city' => [
                'nullable'
            ],
            'billing_address.*.postal_code' => [
                'nullable'
            ],
            'billing_address.*.phone' => [
                'nullable'
            ],
            'billing_address.*.region' => [
                'nullable'
            ],
            'billing_address.*.district' => [
                'nullable'
            ],
            'billing_address.*.boulevard' => [
                'nullable'
            ],
            'billing_address.*.house' => [
                'nullable'
            ],
            'billing_address.*.apartment' => [
                'nullable'
            ],
            'billing_address.*.longitude' => [
                'nullable'
            ],
            'billing_address.*.latitude' => [
                'nullable'
            ],
            'billing_address.*.country_id' => [
                'nullable',
                'integer',
                Rule::exists('world_countries', 'id')->where('active', true)
            ]
        ];
        $shipmentAddress = [
            'shipment_address' => [
                'sometimes',
                'nullable',
                'array'
            ],
            'shipment_address.*.first_name' => [
                'nullable'
            ],
            'shipment_address.*.last_name' => [
                'nullable'
            ],
            'shipment_address.*.company' => [
                'nullable'
            ],
            'shipment_address.*.street_address' => [
                'nullable'
            ],
            'shipment_address.*.province' => [
                'nullable'
            ],
            'shipment_address.*.floor' => [
                'nullable'
            ],
            'shipment_address.*.city' => [
                'nullable'
            ],
            'shipment_address.*.postal_code' => [
                'nullable'
            ],
            'shipment_address.*.phone' => [
                'nullable'
            ],
            'shipment_address.*.region' => [
                'nullable'
            ],
            'shipment_address.*.district' => [
                'nullable'
            ],
            'shipment_address.*.boulevard' => [
                'nullable'
            ],
            'shipment_address.*.house' => [
                'nullable'
            ],
            'shipment_address.*.apartment' => [
                'nullable'
            ],
            'shipment_address.*.longitude' => [
                'nullable'
            ],
            'shipment_address.*.latitude' => [
                'nullable'
            ],
            'shipment_address.*.country_id' => [
                'nullable',
                'integer',
                Rule::exists('world_countries', 'id')->where('active', true)
            ]
        ];
        $items = [
            'items' => [
                'required',
                'array',
                'min:1'
            ],
            'items.*' => [
                'required',
                'array'
            ],
            'items.*.product_id' => [
                'required',
                'integer'
            ],
            'items.*.color_id' => [
                'nullable',
                'integer'
            ],
            'items.*.size_id' => [
                'nullable',
                'integer'
            ],
            'items.*.quantity' => [
                'required',
                'integer',
                'min:1'
            ],
            'items.*.notes' => [
                'nullable',
                'max:200'
            ],
        ];
        return array_merge($billingAddress, $shipmentAddress, $items, [
            'delivery_option_id' => [
                'required',
                'integer'
            ],
            'payment_id' => [
                'required',
                'integer'
            ],
            'address_id' => [
                'nullable',
                'integer'
            ],
            'coupon_id' => [
                'nullable',
                'integer'
            ],
            'notes' => [
                'nullable',
                'max:200'
            ],
            'payment_platform' => [
                'nullable',
                'max:200'
            ]
        ]);
    }

    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(Response::failure($validator->errors()->first()));
    }
}
