<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Support\Facades\Response;

class AboutRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        return [
            'text_ar' => [
                'required'
            ],
            'text_en' => [
                'required'
            ],
            'phone' => [
                'required'
            ],
            'address' => [
                'required'
            ],
            'email' => [
                'required',
                'email'
            ],
            'image' => [
                'nullable'
            ],
            'facebook' => [
                'required'
            ],
            'instagram' => [
                'required'
            ],
            'twitter' => [
                'required'
            ],
            'apple' => [
                'required'
            ],
            'google' => [
                'required'
            ],
            'website_link' => [
                'required'
            ],
            'privacy_policy_en' => [
                'required'
            ],
            'terms_and_conditions_en' => [
                'required'
            ],
            'privacy_policy_ar' => [
                'required'
            ],
            'terms_and_conditions_ar' => [
                'required'
            ],
        ];
    }

    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(Response::failure($validator->errors()->first()));
    }
}
