<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\UserCategoryRequest;
use App\Models\UserCategory;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;

class UserCategoryController extends Controller
{
    public function __construct()
    {
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('has_permission:view_user_category')->only(['export', 'index', 'show']);
            $this->middleware('has_permission:update_user_category')->only(['update']);
            $this->middleware('has_permission:create_user_category')->only(['store']);
            $this->middleware('has_permission:delete_user_category')->only(['destroy']);
        }
    }

    public function index():JsonResponse
    {
        return Response::success(
            UserCategory::query()
        );
    }
    public function store(UserCategoryRequest $request):JsonResponse
    {
        return Response::success(UserCategory::query()->create($request->validated()));
    }

    public function show(UserCategory $userCategory):JsonResponse
    {
        return Response::success(
            $userCategory->load(['users'])
        );
    }
    public function update(UserCategoryRequest $request,UserCategory $userCategory):JsonResponse
    {
        $userCategory->update($request->validated());
        return Response::success(
            $userCategory->refresh()
        );
    }
    public function destroy(UserCategory $userCategory):JsonResponse
    {
        $userCategory->delete();
        return Response::success([]);
    }




}
