<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\PlatformSettingRequest;
use App\Models\PlatformSetting;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Response;

class PlatformSettingController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:api');
        $this->middleware('has_permission:view_platformSettings')->only(['index']);
        $this->middleware('has_permission:update_platformSettings')->only(['update']);
    }

    public function index(): JsonResponse
    {
        return Response::success(PlatformSetting::query()->first());
    }

    public function update(PlatformSettingRequest $request): JsonResponse
    {
        PlatformSetting::query()->forceDelete();
        return Response::success(PlatformSetting::query()->create($request->validated()));
    }
}
