<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\PaymentRequest;
use App\Models\Payment;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Response;

class PaymentController extends Controller
{

    public function __construct()
    {
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('has_permission:view_payment')->only(['index', 'export', 'show']);
            $this->middleware('has_permission:create_payment')->only(['store']);
            $this->middleware('has_permission:update_payment')->only(['update']);
            $this->middleware('has_permission:delete_payment')->only(['delete']);
        }
    }

    public function index(): JsonResponse
    {
        return Response::success(
            Payment::search(request()->query('word_filter'))
                ->active(request()->query('activated'))
                ->orderByDesc('activated')
        );
    }

    public function show($id): JsonResponse
    {
        return Response::success(
            Payment::query()->find($id)
        );
    }

    public function store(PaymentRequest $request): JsonResponse
    {
        $input = $request->validated();
        return Response::success(Payment::query()->create($input));

    }

    public function update(PaymentRequest $request, $id): JsonResponse
    {
        $payment = Payment::query()
            ->findOrFail($id);
        $payment->update($request->validated());
        return Response::success($payment);
    }

    public function destroy($id): JsonResponse
    {
        $payment = Payment::query()->findOrFail($id);
        if ($payment->products()->count() > 0) {
            return Response::failure(__('common.error_delete_item'));
        }
        $payment->delete();
        return Response::success(null);
    }
}
