<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\OutOfStockRequest;
use App\Models\OutOfStock;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Response;

class OutOfStockController extends Controller
{
    public function __construct()
    {
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('has_permission:view_outOfStock')->only(['index', 'sh']);
            $this->middleware('has_permission:create_outOfStock')->only(['store']);
            $this->middleware('has_permission:update_outOfStock')->only(['update']);
            $this->middleware('has_permission:delete_outOfStock')->only(['delete']);
        }
    }

    public function index(): JsonResponse
    {
        return Response::success(
            OutOfStock::query()
        );
    }

    public function show($id): JsonResponse
    {
        return Response::success(
            OutOfStock::query()->find($id)
        );
    }

    public function store(OutOfStockRequest $request): JsonResponse
    {
        $input = $request->validated();
        return Response::success(OutOfStock::query()->create($input)->load([]));
    }

    public function update(OutOfStockRequest $request, $id): JsonResponse
    {
        $OutOfStock = OutOfStock::query()
            ->findOrFail($id);
        $OutOfStock->update($request->validated());
        return Response::success($OutOfStock);
    }

    public function destroy($id): JsonResponse
    {
        $OutOfStock = OutOfStock::query()->findOrFail($id);
        if ($OutOfStock->products()->count() > 0) {
            return Response::failure(__('common.error_delete_item'));
        }
        $OutOfStock->delete();
        return Response::success(null);
    }
}
