<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\UserRequest;
use App\Models\User;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Response;
use Khsing\World\Models\City;

class ManagerController extends Controller
{

    public function __construct()
    {
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('has_permission:configure_manager');
        }
    }

    public function index(): JsonResponse
    {
        return Response::success(
            User::search(request()->query('word_filter'))
                ->phoneFilter(request()->query('phone_filter'))
                ->active(request()->query('activated'))
                ->where('role', '=', 'Admin')
        );
    }

    public function show($id): JsonResponse
    {
        return Response::success(
            User::query()
                ->with(['city', 'appPreference', 'roles.permissions'])
                ->where('role', '=', 'Admin')
                ->find($id)
        );
    }

    public function store(UserRequest $request): JsonResponse
    {
        DB::beginTransaction();
        $userInput = $request->validated();
        $userInput['verified'] = $userInput['activated'] = '1';
        $userInput['timezone'] = City::query()->find($request->input('city_id'))->country->timezone;
        $userInput['role'] = 'Admin';
        Arr::forget($userInput, ['role_id']);
        $user = User::query()->create($userInput);
        $user->roles()->sync($request->input('role_id'));
        DB::commit();

        return Response::success($user->load(['city', 'appPreference', 'roles.permissions']));
    }

    public function update(UserRequest $request, $id): JsonResponse
    {
        $user = User::query()
            ->findOrFail($id);
        $userInput = $request->validated();
        $userInput['timezone'] = City::query()->find($request->input('city_id'))->country->timezone;
        $userInput['role'] = 'Admin';
        Arr::forget($userInput, ['role_id']);
        $user->update($userInput);
        $user->roles()->sync($request->input('role_id'));
        return Response::success($user->load(['city', 'appPreference', 'roles.permissions']));
    }

    public function destroy($id): JsonResponse
    {
        DB::beginTransaction();
        User::query()->where('role', '=', 'Admin')->findOrFail($id)->delete();
        DB::commit();
        return Response::success(null);

    }
}
