<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\FaqRequest;
use App\Models\Faq;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Response;

class FaqController extends Controller
{

    public function __construct()
    {
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('has_permission:view_faq')->only(['export', 'index', 'show']);
            $this->middleware('has_permission:update_faq')->only(['update']);
            $this->middleware('has_permission:create_faq')->only(['store']);
            $this->middleware('has_permission:delete_faq')->only(['destroy']);
        }
    }

    public function index(): JsonResponse
    {
        return Response::success(
            Faq::query()
        );
    }

    public function show($id): JsonResponse
    {
        return Response::success(
            Faq::query()->find($id)
        );
    }

    public function store(FaqRequest $request): JsonResponse
    {
        return Response::success(Faq::query()->create($request->validated()));

    }

    public function update(FaqRequest $request, $id): JsonResponse
    {
        $brand = Faq::query()
            ->findOrFail($id);
        $brand->update($request->validated());
        return Response::success($brand);
    }

    public function destroy($id): JsonResponse
    {
        Faq::query()->findOrFail($id)->delete();
        return Response::success(null);

    }
}
