<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\CountryRequest;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Response;
use Khsing\World\Models\Country;

class CountryController extends Controller
{
    public function __construct()
    {
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('has_permission:view_country')->only(['index', 'show']);
            $this->middleware('has_permission:update_country')->only(['update']);
        }
    }

    public function index(): JsonResponse
    {
        return Response::success(Country::search(request()->query('word_filter'))
            ->active(request()->query('activated'))
            ->orderByDesc('active'));
    }

    public function show($id): JsonResponse
    {
        return Response::success(Country::query()->with(['cities'])->find($id));
    }

    public function update(CountryRequest $request, $id): JsonResponse
    {
        $country = Country::query()
            ->findOrFail($id);
        $country->update($request->validated());
        return Response::success($country->load([]));
    }
}
