<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Slider;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;

class SliderController extends Controller
{
    public function baseQuery(string $type='main')
    {
        return Slider::query()
            ->where('type','=',$type)
            ->with('category.subCategoriesRecursive')
            ->withSort()
            ->get();
    }
    public function indexMain():JsonResponse
    {
        return Response::success($this->baseQuery());
    }
    public function indexSecondary():JsonResponse
    {
        return Response::success($this->baseQuery('secondary'));
    }
    public function show(Slider $slider)
    {
        return Response::success($slider->load('category.subCategoriesRecursive'));
    }
}
