<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Http\Requests\ContactRequest;
use App\Models\Contact;
use App\Services\MailService;
use Carbon\Carbon;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Response;

class ContactController extends Controller
{
    private $mailService;


    public function __construct(MailService $mailService)
    {
        $this->mailService = $mailService;
    }

    public function store(ContactRequest $request): JsonResponse
    {
        $contact = Contact::query()->create($request->validated());
        $this->mailService->sendToSupport(new \App\Mail\ContactRequest(Carbon::now()
            , $contact->name, $contact->email, $contact->phone_number, $contact->message));
        return Response::success($contact);
    }
}
