<?php

namespace App\Console;

use App\Models\Notification;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Illuminate\Support\Facades\Log;
use Torann\Currency\Console\Cleanup;
use Torann\Currency\Console\Manage;
use Torann\GeoIP\Console\Clear;
use Torann\GeoIP\Console\Update;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        \Torann\Currency\Console\Update::class,
        Cleanup::class,
        Manage::class,

        Update::class,
        Clear::class
    ];

    /**
     * Define the application's command schedule.
     *
     * @param Schedule $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // $schedule->command('inspire')->hourly();
        // cd ~/laravel && php artisan currency:update -o 1>> ~/laravel/log_laravel 2>&1
        // cd ~/laravel && php artisan geoip:update 1>> ~/laravel/log_laravel 2>&1

        $schedule->command('model:prune', [
            '--model' => [Notification::class],
        ])->hourly();

        $schedule->call(function () {
            Log::channel('daily')->info("Cron Hourly");
        })->hourly();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');
    }
}
